<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>CFTT Federated Testing CD - test a Mobile Device tool</title>
<link rel="stylesheet" type="text/css" href="../css/reset.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/main_style.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/layout.css" media="screen" />

<style>

	table, th, td {
	   border-collapse: collapse;
	   border: 1px solid black;
	   } 
	tr {
	   border-collapse: collapse;
	   border: 2px solid black;
	   } 

	td {text-align: center}
</style>

</head>
<body id="menu1">
	<div id="mainWrapper">
		<div id="topBannerContainer">
			<div id="logoContainer">
  				<img src="../images/banner.png" alt="CFTT Federated Testing - NIST">
			</div>
            <!-- Menu Starts-->
			<div id="menuContainer">
                          <?php
                                include '../include/global.php';
                                print_main_horizontal_menu_contents();
                          ?>

    		</div>
            <!-- Menu Ends-->
		</div>
		<!-- TopBanner Ends-->
	  
		<!-- Main Content Starts-->	
		<div id="subContentContainer">
		  <div id="leftContent">
		    <div id="leftLinks">
				<div>
<?php
include '../include/mdt-global.php';
?>
		    	</div>
		    </div>
		  </div>			
		  <div id="rightContent">
<!--		    <div id="breadcrumb"><a href="../Federated_Testing_Home_Page.php">Home</a> > Test a disk imaging tool</div>-->
		    <div id="breadcrumb"><a href="../Federated_Testing_Home_Page.php" class="nav">Home</a> 
				&gt; <a href="mdt.php" class="nav">Mobile Device Testing Home</a> 
<!--				&gt; Mobile Tool Test</div>-->
				&gt; Mobile Tool Testing - Test Runs</div>

<!--<h1>Mobile Tool Test - Mobile Test Runs</h1>-->
<h1 style="font-size:1.8em">Mobile Tool Testing - Test Runs</h1>

<!--<div style="padding: 1em 1em 0.5em 1em; background: #eeeeee url(" images="" ui-bg_highlight-soft_100_eeeeee_1x100.png")="" 50%="" top="" repeat-x;"="">-->
<!-- ======================================================== -->

<p>This page describes the procedures to be performed when acquiring a mobile device 
or SIM/UICC as part of testing a mobile forensics data extraction tool. It is divided into 
five <i>Test Runs</i>, each of which tests various aspects of the tool.</p>

<p>The <b>Acquire All</b> <i>Test Run</i> is essential. The remaining test runs are 
dependent upon the forensic tool’s capabilities and your organizational requirements. 
Test results are recorded in the “<a href="ft_mdt_select_results.php">Record Device 
Test Results</a>” section of Federated Testing.</p>

<p>The table below identifies <i>Essential</i> and <i>Optional</i> Test Runs.</p>

<p><i>Essential</i> and <i>Optional</i> Test Runs</p>
<table class="bordered_table" style="position:relative;top:-13px;">
<!--<table>-->
<!--
<caption style="font-size: 1.15em;">
<i>Essential</i> and <i>Optional</i> Test Runs
</caption>
-->
<tbody><tr>
<th><b>Fed Testing - Mobile</b></th>
<th><b>Acquire All</b></th>
<th><b>Connectivity</b></th>
<th><b>Case File/Data Protection</b></th>
<th><b>Hashing</b></th>
<th><b>SIM/UICC Authentication</b></th>
</tr>
<tr>
	<td style="text-align: left"><i>Essential</i></td><td>x</td><td></td><td></td><td></td><td></td>
</tr>
<tr>
	<td style="text-align: left"><i>Optional</i></td><td></td><td>x</td><td>x</td><td>x</td><td>x</td>
</tr>
</tbody></table>

<br>
<h2 style="font-size:1.7em; color:#008000"><b>1. Acquire All</b></h2>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: This test run is performed once per mobile device.</b></p>
<ul>
<li>Complete data extraction from the internal memory of the target mobile device using 
the recommended data cable.</li>
<li>If acquiring a SIM/UICC, complete data extraction from its internal memory using the 
recommended card reader.</li>
<li>This test run shows the tool’s ability to extract data from a mobile device and/or a SIM/UICC.</li>
</ul>
<p><i>Instructions:<br></i></p>
<ol><i>
<li>Refer to the mobile forensic tool documentation on establishing connectivity and data 
extraction specifics for the mobile device and/or SIM/UICC.</li>
<li>Initialize the mobile forensic tool to be tested and begin the test run. Use the tool 
to “acquire all” data from the mobile device and/or SIM/UICC.</li>
<li>After a successful data extraction of the target mobile device and/or SIM/UICC, analyze 
and document the results produced by the mobile forensic tool using the 
“<a href="ft_mdt_select_results.php">Record Device Tests Results</a>” section of Federated 
Testing.</li>
</i></ol>	
	
<br><h2 style="font-size:1.7em; color:#008000"><b>2. Connectivity</b></h2>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: This test run is performed once per tool.</b></p>
<ul>
<li>Disrupt connectivity during data extraction for a mobile device or SIM/UICC.  This is accomplished by removing the cable from the mobile device or removing the SIM/UICC from the card reader.</li>
<li>This test run shows the tool’s ability to inform the user that connectivity has been disrupted.</li>
</ul>
<p><i>Instructions:<br></i></p>
<ol><i>
<li>Initialize the mobile forensic tool to be tested.  Establish connectivity to the target mobile device or SIM/UICC and begin the data extraction.</li>
<li><b>For Mobile Devices</b>: During the data extraction pull the cable from the mobile device (<b>NOT</b> from the forensic workstation).<br><br>
<img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-4px 0;"> <b>NOTE: The mobile forensic tool may take 3-5 minutes to inform the user that connectivity has been disrupted.  This occurs while the software is attempting to re-establish connectivity.</b></li>
<li><b>For SIM/UICCs</b>: During the data extraction remove the SIM/UICC from the card reader.<br><br>
<img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-4px 0;"> <b>NOTE: The mobile forensic tool may take 3-5 minutes to inform the user that connectivity has been disrupted.  This occurs while the software is attempting to re-establish connectivity.</b></li>
<li>Document the results produced by the mobile forensic tool in the “<a href="ft_mdt_select_results.php">Record Device Tests Results</a>” section of Federated Testing.</li>
</i></ol>

<br><h2 style="font-size:1.7em; color:#008000"><b>3. Case File/Data Protection</b></h2>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: The mobile forensic tool may provide users with the ability to save data extracted to a “case file.”  Case files provide users with the ability to re-open and re-examine data acquired. If the mobile forensic tool does not support the creation of a case file, SKIP this test run.</b></p>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: This test run is performed once per tool, not per device.</b></p>
<ul>
<li>Modify the content of a tool-generated case file with a hex editor. Document the modifications and re-open the modified case file with the mobile forensic tool.</li>
<li>This test run shows the tool’s ability to inform the user the case file has been modified.</li>
</ul>
<p><i>Instructions:</i><br>
</p>
<ol><i>
<li>After successfully extracting data from the mobile device or SIM/UICC create and save the case file e.g., Toolname_CaseFileModification.</li>
<li>Open the Toolname_CaseFileModification case file with a hex editor.</li>
<li>If the case file is presented in plaintext, modify recognizable data e.g., (contact entries, text messages, calendar, memos). Document the modifications and re-save the case file.</li>
<li>If the case file is not presented in plaintext, select and modify any character(s). Document the modified hex address locations and re-save the case file.</li>
<li>Attempt to re-open the modified case file with the mobile forensic tool.<br><br>
<img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-4px 0;"> <b>NOTE: The mobile forensic tool should provide the user with a message stating the case file has been modified. If the case file is re-opened without error and the modifications are present, the results are recorded as “Not as Expected.” If the case file is re-opened without error and the modifications are NOT present, the results are recorded as “As Expected.”</b></li>
<li>Document the results produced by the mobile forensic tool in the “<a href="ft_mdt_select_results.php">Record Device Tests Results</a>” section of Federated Testing.</li>
</i></ol>

<br><h2 style="font-size:1.7em; color:#008000"><b>4. Hashing</b></h2>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: Hash values calculated for the overall case file and/or individual files are often presented either in the mobile forensic tool preview-pane (GUI) or the generated report. If the mobile forensic tool does not calculate hashes for either the case file or individual files, SKIP this test run.</b></p>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: This test run is performed once per tool, not per device.</b></p>
<ul>
<li>Examine the tool’s ability to calculate hashes for individually acquired files and/or the generated case file.</li>
<li>This test run shows the tool’s ability to calculate hashes for individual files and/or the overall case file.</li>
</ul>
<p><i>Instructions:</i><br></p>
<ol><i>
<li>Refer to the mobile forensic tool documentation to determine the tool’s support for generating overall case file and/or individual file (e.g., graphics, audio, video, etc.) hashes.</li>
<li>After a successful data extraction of the target mobile device and/or SIM/UICC, observe the output from the mobile forensic tool to determine if hashes were calculated for individually acquired files and/or an overall generated case file.</li>
<li>Perform a second acquisition of the mobile device and/or SIM/UICC.  Compare individual file hashes calculated for consistency.</li>
<li>Document the results produced by the mobile forensic tool in the “<a href="ft_mdt_select_results.php">Record Device Tests Results</a>” section of Federated Testing.</li>
</i></ol>

<br><h2 style="font-size:1.7em; color:#008000"><b>5. SIM/UICC Authentication</b></h2>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: If the mobile forensic tool does not support the acquisition of a SIM/UICC, SKIP this test run.</b></p>
<p><img src="../images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-2px 0;"> <b>NOTE: This test run is performed once per tool, not per SIM/UICC.</b></p>
<h3 style="font-size:1.6em; color:#9D0F19">PIN:</h3>
<ul>
<li>Complete data extraction of an unlocked SIM/UICC.</li>
<li>Protect the SIM/UICC by activating the 4-digit PIN.</li>
<li>Complete data extraction of the PIN protected SIM/UICC.</li>
<li>This test run shows the tool’s ability to complete the data extraction of a PIN protected SIM/UICC and accurately report the remaining number of PIN attempts.</li>
</ul>
<h3 style="font-size:1.6em; color:#9D0F19">PUK:</h3>
<ul>
<li>Initiate data extraction of a PUK protected SIM/UICC; input the incorrect PUK code.</li>
<li>This test run shows the tool's ability to decrement and accurately report the remaining number of PUK attempts.</li>
</ul>
<p><i>Instructions:</i><br></p>
<ol><i>
<li>These test runs require two SIM/UICCs:
	<ol  style="list-style-type: lower-alpha;">
	<li>4-digit PIN protected SIM/UICC.
		<ol style="list-style-type: lower-roman;">
			<li>PIN protected SIM/UICCs are created by enabling the security settings within the mobile device.  Activating the PIN for the SIM/UICC varies per make/model of mobile devices.</li>
		</ol>
	</li>
	<li>A SIM/UICC requiring a Pin Unlocking Key (PUK).
		<ol  style="list-style-type: lower-roman;">
			<li>A SIM/UICC requiring a PUK code is created by incorrectly inputting the 4-digit PIN (generally 3 times) on a PIN protected SIM/UICC.</li>
		</ol>
	</li>
	</ol>
</li>
<li>Attempt data extraction from the PIN protected SIM/UICC.  The data acquired from the mobile forensic tool should be consistent with the data acquired when the SIM/UICC was not locked with a PIN.</li>
<li><b>PIN SIM/UICC</b>: To test that the mobile forensic tool properly decrements the PIN attempts, input an incorrect PIN and observe the remaining attempts.</li>
<li><b>PUK SIM/UICC</b>: To test that the mobile forensic tool properly decrements the PUK attempts, input an incorrect PUK and observe the remaining attempts.</li>
<li>Document the results produced by the mobile forensic tool in the “<a href="ft_mdt_select_results.php">Record Device Tests Results</a>” section of Federated Testing.</li>
</i></ol>
<br>
<!--<p><a href="mdt.php">Return to Mobile Device Home Page</a></p>-->

<p>
If you are finished running tests, click 
<?php
// if doing dev work on mac, want to pass /tmp as path to log drive; if on Linux,
// pass /media/FT-LOGS 
$mac = '/Applications/MAMP';
//$linux = '/usr/lib/cgi-bin';
$prtpath = get_cgipath(true);
if (file_exists($mac)){
  // if on mac, 
  echo '<a href="/generatefinalreport.php?ref=md&path=/tmp">';
} else {
  // else, on linux,
  //echo '<a href="/generatefinalreport.php?ref=md&path=/media/cftt/FT-LOGS">';
  echo '<a href="/generatefinalreport.php?ref=md&path='.$prtpath.'">';
}
?> 
Generate a Test Report</a> to continue to the next step and create a draft test report.
</p>

<!-- ======================================================== -->
<!--</div>		        -->

			</div>
		<div class="push"></div>
	</div>
    <!-- Footer Starts-->
   <!-- Footer Starts-->
        <?php
     $fn = $_SERVER["SCRIPT_FILENAME"];
          print_footer_contents($fn);
        ?>
    <!-- Footer Ends-->

    <!-- Footer Ends-->
<!--
	<div class="footer"><div class="footerContentsWrapper"><p>The National Institute of Standards and Technology (NIST) is an agency of
 the U.S. Commerce Department.</p><br><br><p class="links"><a href="../Federated_Testing_Home_Page.php">Home</a>
 &nbsp;/&nbsp; <a href="http://localhost/about.php">About</a> &nbsp;/&nbsp;
<a href="mobile-definitions.html">Glossary of Mobile Device Terms</a>
&nbsp;/&nbsp; <a href="http://localhost/FAQ.php">FAQs</a> &nbsp;/&nbsp;
<a href="http://localhost/contacts.php">Contacts</a><br><br>Federated Testing Version:
1.1-3<br>Release Date: --/--/201-</p></div></div>    <!-- Footer Ends-->



</div></body></html>
