<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>CFTT Federated Testing CD - test a Mobile Device tool</title>
<link rel="stylesheet" type="text/css" href="../css/reset.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/main_style.css" media="screen" />
<link rel="stylesheet" type="text/css" href="../css/layout.css" media="screen" />
<style>
	table, th, td {
	   border-collapse: collapse;
	   border: 1px solid black;
	   } 
	tr {
	   border-collapse: collapse;
	   border: 2px solid black;
	   } 
</style>
</head>
<body id="menu1">
	<div id="mainWrapper">
		<div id="topBannerContainer">
			<div id="logoContainer">
  				<img src="../images/banner.png" alt="CFTT Federated Testing - NIST">
			</div>
            <!-- Menu Starts-->
			<div id="menuContainer">
                          <?php
                                include '../include/global.php';
                                print_main_horizontal_menu_contents();
                          ?>
    		</div>
            <!-- Menu Ends-->
		</div>
		<!-- TopBanner Ends-->
	  
		<!-- Main Content Starts-->	
		<div id="subContentContainer">
		  <div id="leftContent">
		    <div id="leftLinks">
<div>
<?php
include '../include/mdt-global.php';
?>
		    </div>
		    </div>
		  </div>			
		  <div id="rightContent">
			<div id="breadcrumb"><a href="../Federated_Testing_Home_Page.php" class="nav">Home</a> &gt; <a href="/mobiledevice/mdt.php" class="nav"> Mobile Device Testing Home</a> &gt; Recording Device Test Results</div>
<!------------------------------------------------------------- -->
<!--<div style="padding: 0em 1em .25em .5em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">-->
<?php
			  
$continue = 1;

// is_ftlogs_mounted() returns the path to where we should store log files (e.g.,  
// /tmp or /media/FT-LOGS). It also checks if the user has mounted their log drive.
// is_ftlogs_mounted() will return 0/false and print an error message if the 
// user's log drive is not mounted
$root = is_ftlogs_mounted(TRUE);

if (!$root) { 
	// if the user's log drive isn't mounted, don't continue
	$continue = 0;
}
	
// if the user's log drive isn't mounted, don't continue
if ($continue){
	echo '<h1 style="font-size:1.8em">Recording Device Test Results (3 of 3)</h1>';
	echo '<h2 style="font-size:1.7em; color:#008000">Saving Device Test Results</h2>';

	extract($_POST);
	$have_phones = FALSE;
	$dname = sprintf ("%s/devices.txt",$root);
	// cycle through our list of phones to find make and model
	if (file_exists($dname)){
		$dfile = fopen($dname,"r");
		$p_line = fgets($dfile);
		while (!feof($dfile)){
			//$the_phones [] = $p_line;
			$pxp = explode(';',$p_line);
			// if the current device is the selected device, get its make and model
			if ($pxp[0] == $selected_device){
				$manufacturer = $pxp[1];
				$model = $pxp[2];
			}
			$p_line = fgets($dfile);
			$have_phones = TRUE;
		}
		fclose($dfile);
	}

	$pname = sprintf("%s_results.txt",$selected_device);
	$qname = sprintf("%s_comments.txt",$selected_device);
	// can we open the results file?
	if (!$pfile = fopen($root.'/'.$pname,"w")){
		echo "<p><b>Error: <i>".basename($_SERVER['PHP_SELF'])."</i> encountered ";
		echo "an error trying to write to ".$root."/".$pname.". Device ";
		echo "results COULD NOT be saved.</b></p>";
		$continue = 0;
	} 
	// can we open the comments file?
	if (!$qfile = fopen($root.'/'.$qname,"w")) {
		echo "<p><b>Error: <i>".basename($_SERVER['PHP_SELF'])."</i> encountered ";
		echo "an error trying to write to ".$root."/".$qname.". Device ";
		echo "results COULD NOT be saved.</b></p>";
		$continue = 0;
	}
	// if we were able to open the files to write, continue
	if ($continue){
		$keys = array_keys($_POST);
		foreach ($keys as $dongxi){
			$out = sprintf("%s:%s\n",$dongxi,$_POST[$dongxi]);
			if ($dongxi != 'select' && $dongxi != 'selected_device'){
				$kind = explode('_',$dongxi);
				if ($kind[0] != 'comm'){
					fwrite($pfile,sprintf("%s:%s\n",$dongxi,$_POST[$dongxi]));
				} else if (strlen($_POST[$dongxi]) > 0){
					fwrite($qfile,sprintf("<MDC element=%s>\n",$dongxi));
					fwrite($qfile,sprintf("%s\n",$_POST[$dongxi]));
					fwrite($qfile,"</MDC>\n");
				}
			}
		}
		fclose ($pfile);
		fclose ($qfile);
		// tell the user what we did
		echo "'".$pname."' and '".$qname."' written to '".$root."'<br><br>";
		echo "<p><i>Success! ".$manufacturer." ".$model." device test results saved!!</i></p>";	
	}

	echo '<!------------------------------------------------------------- -->';
	echo '<!--</div>		        -->';
	echo '<p>Click <a href="ft_mdt_test_tool.php">Mobile Tool Test</a> to continue ';
	echo 'running tests for your tool.</p>';
	echo '<p>Click <a href="ft_mdt_select_results.php">Record Device Test Results</a> to record the test results for another device.</p>';
	echo '<p>If you are finished recording the results for your test devices, click ';

	// if doing dev work on mac, want to pass /tmp as path to log drive; if on Linux,
	// pass /media/FT-LOGS 
	$mac = '/Lighty2Go/cgi-bin';
	$prtpath = get_cgipath(TRUE);
	//print "THE PATH IS " . $prtpath;
	//$linux = '/Lighty2Go/cgi-bin';
	if (file_exists($mac)){
	  // if on mac, 
	  echo '<a href="/generatefinalreport.php?ref=md&path=/tmp">';
	} else {
	  // else, on linux,
	  //echo "no";
	  echo '<a href="/generatefinalreport.php?ref=md&path='.$prtpath.'">';
	}

	echo 'Generate a Test Report</a> to continue to the next step and create a draft test report.</p>';
}
?>			
			</div>
		<div class="push"></div>
	</div>
    <!-- Footer Starts-->
        <?php
     $fn = $_SERVER["SCRIPT_FILENAME"];
          print_footer_contents($fn);
        ?>
    <!-- Footer Ends-->

</div></body></html>
