<?php
function addRemovePresskey($filename, $add) {
	$sbs = file_get_contents($filename, false);
	if ($sbs != false) {
		$searchFor = $add ? 'false' : 'true';
		$replaceWith = $add ? 'true' : 'false';
		$sbs = str_replace('SET presskey=' . $searchFor, 'SET presskey=' . $replaceWith, $sbs);
	}

	$filehandle = fopen($filename, 'w');
	fwrite($filehandle, $sbs);
	fclose($filehandle);
}

function hasPresskey() {
	$sbs = file_get_contents('../../base_files/Start-Both-Servers.bat', false);
	return strpos($sbs, 'SET presskey=false') === false;
}

function startServers($filename, $start) {
	$sbs = file_get_contents($filename, false);
	if ($sbs != false) {
		$searchFor = $start ? 'false' : 'true';
		$replaceWith = $start ? 'true' : 'false';
		$sbs = str_replace('SET startservers=' . $searchFor, 'SET startservers=' . $replaceWith, $sbs);
	}

	$filehandle = fopen($filename, 'w');
	fwrite($filehandle, $sbs);
	fclose($filehandle);
}

function isStartingservers() {
	$sbs = file_get_contents('../../base_files/set-path.bat', false);
	return strpos($sbs, 'SET startservers=false') === false;
}

function setSafemode($on) {
	$filename = '../../PHP/php.ini';
	$phpini = file_get_contents($filename, false);
	if ($phpini != false) {
		$searchFor = $on ? 'Off' : 'On';
		$replaceWith = $on ? 'On' : 'Off';
		$sbs = preg_replace('/(\s)safe_mode = ' . $searchFor . '/', '${1}safe_mode = ' . $replaceWith, $phpini);
	}

	$filehandle = fopen($filename, 'w');
	fwrite($filehandle, $sbs);
	fclose($filehandle);
}

function isSafemode() {
	$phpini = file_get_contents('../../PHP/php.ini', false);
	return preg_match('/\ssafe_mode = On/', $phpini) > 0;
}

function setShortopentag($on) {
	$filename = '../../PHP/php.ini';
	$phpini = file_get_contents($filename, false);
	if ($phpini != false) {
		$searchFor = $on ? 'Off' : 'On';
		$replaceWith = $on ? 'On' : 'Off';
		$sbs = preg_replace('/(\s)short_open_tag = ' . $searchFor . '/', '${1}short_open_tag = ' . $replaceWith, $phpini);
	}

	$filehandle = fopen($filename, 'w');
	fwrite($filehandle, $sbs);
	fclose($filehandle);
}

function isShortopentag() {
	$phpini = file_get_contents('../../PHP/php.ini', false);
	return preg_match('/\sshort_open_tag = On/', $phpini) > 0;
}
?>