/**
 * This panel displays XML and ER7 files which have been generated
 */

// JDK
import java.io.IOException;
import java.util.Observer;
import java.util.Observable;

// AWT
import java.awt.Dimension;

// Swing
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.BoxLayout;
import javax.swing.BorderFactory;

// XML
import javax.xml.parsers.ParserConfigurationException;

// SAX
import org.xml.sax.SAXException;  

// DOM
import org.w3c.dom.Document;

public class ICSDisplayPanel extends JPanel implements Observer {

    private XMLView xmlView;
   

    /** 
     * Constructor
     */
    public ICSDisplayPanel() {
	setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));

	// XMLView
	xmlView = new XMLView();
	JScrollPane xmlScrollPane = new JScrollPane(xmlView);
	xmlScrollPane.setPreferredSize(new Dimension(100, 260));



	// SplitPane 
	JPanel p0 = new JPanel();
	p0.setLayout(new BoxLayout(p0, BoxLayout.LINE_AXIS));
	//JSplitPane sp = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, xmlScrollPane, er7ScrollPane);
	p0.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

	p0.add(xmlScrollPane);
	add(p0);
    }

    /**
     * MVC
     * @param o The observable object
     * @param arg An argument passed to the notifyObservers method
     */
    public void update(Observable o, Object arg) {
	if(o instanceof ICSModel) {
	    if(arg instanceof MVCArg) {
		if("generateXML".equals(((MVCArg)arg).getName())) {
		   System.err.println("In ICSDisplay UPDATE");
		   Document doc = (Document)((MVCArg)arg).getOValue();
		   xmlView.displayMessage(doc); 
		}
		
		else if("init".equals(((MVCArg)arg).getName())) {
		    init();
		}
	    }
	}
    }

    /**
     * Init the panel
     */
    public void init() {
	xmlView.reset();
    }
}
