/**
* This is the MVC model for the batch GUI
*/



//JDK
//package src;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Observable;
import java.util.Vector;
import java.util.StringTokenizer;
import java.util.Enumeration;

//Swing
import javax.swing.tree.DefaultMutableTreeNode;

//XML
import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.ParserConfigurationException;

//DOM
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//SAX
import org.xml.sax.SAXException;


public class ValidateXML extends Observable {
	
   String selectedFile;
   String fileType;
   String setValidate;
   DefaultMutableTreeNode treeNode;  
   
   public void setSelectedFile(String SELECTEDFILE) {
   	
   	selectedFile = "C:/x73-Tool/xml/"+SELECTEDFILE;
   }

   /**
    * Get the structure
    * @return The structure
    */
   public String getSelectedFile() {
	return selectedFile;
   }
  
   
   public void setFileType(String FILETYPE) {
   	
   	fileType = FILETYPE;
   }

   /**
    * Get the file type
    * 
    */
   public String getFileType() {
	return fileType;
   }
   
   public void setValidateEnable() {
   	
   	setValidate = "validate";
   	setChanged();
    notifyObservers(new MVCArg("validatSelected", setValidate));
   }

   /**
    * Get the file type
    * 
    */
   public String getsetValidate() {
	return setValidate;
   }
   
   public DefaultMutableTreeNode getMainTree(String XMLTOLOAD) throws SAXException, IOException, ParserConfigurationException{

      DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
      DocumentBuilder builder = factory.newDocumentBuilder();
      Document doc = builder.parse(new File("C:/x73-Tool/xml/"+XMLTOLOAD));
	      
      Element docroot = doc.getDocumentElement();	            

      treeNode = processXML(docroot); 
      return treeNode;
   }

   private DefaultMutableTreeNode processXML(Node root) {
	  
      DefaultMutableTreeNode treeNode = null;
      String                 name, value;

      name = root.getNodeName();
      value = root.getNodeValue();

      treeNode = new DefaultMutableTreeNode(root.getNodeType() == Node.TEXT_NODE ? value : name);
	      
      if (root.hasChildNodes()) {

	 NodeList children;

	 int numChildren;
	 Node node;
         String nodeValue;
	        
	 children = root.getChildNodes();
	 if (children != null) {
	    numChildren = children.getLength();
	    for (int j=0; j < numChildren; j++) {
	       node = children.item(j);                 
	       if (node != null) {                     
	 	  if (node.getNodeType() == Node.ELEMENT_NODE) {
	             treeNode.add(processXML(node));
	          }
                  if (node.getNodeType() == Node.TEXT_NODE) {
                     nodeValue = node.getNodeValue();
                     if (nodeValue != null) {
                        nodeValue = nodeValue.trim();
                        if (!nodeValue.equals("\n") && !nodeValue.equals("\r\n") && nodeValue.length() > 0) {
                           treeNode.add(processXML(node));
                        }
                     }
                  }
	       }
	    }
	 }
      }
      return treeNode;
   } 
}
